% Number of points in the interval
num_points = 500;

% Generate 100 points in the interval [-1, 1]
points = linspace(-3+0.001, 3-0.001, num_points);

% Initialize the minimum value and corresponding x, y
min_value = inf;
min_x = NaN;
min_y = NaN;
k = 1;
c0 = 0;

N=2000;


% Define the integrand as an anonymous function
integrand = @(x) 2*exp(-(x.^2)./2);
integrand_1 = @(x) exp((x.^2)./2);

% Loop over all x points
for i = 1:num_points
    x = points(i);
    
    % Loop over all y points
    for j = 1:num_points
        y = points(j);

        if x<y
        
            % Compute the integral
            result_0 = 1./integral(integrand_1, x, y);
            result_1 = (1./integral(integrand, -3, x))+(1./integral(integrand, y, 3));
            result=result_0.*result_1;
          
       
            % Check if the current result is the minimum
            if result < min_value
                min_value = result;
                lower_bound = result./4;
                min_x = x;
                min_y = y;
            end
        end
    end
end

% Display the result
disp(['The minimum integral value is: ', num2str(min_value)]);
disp(['The lower bound value is: ', num2str(lower_bound)]);
disp(['The corresponding x is: ', num2str(min_x)]);
disp(['The corresponding y is: ', num2str(min_y)]);
